<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime as DateTime;

/**
 * Class FourthOfJuly
 *
 * @package DPP\Financial\Time\Holiday
 */
class FourthOfJuly extends Holiday
{
    /**
     * FourthOfJuly constructor.
     */
    public function __construct()
    {
        parent::__construct(4, "Fourth of July", "fourth_of_july");
    }

    /**
     * @param DateTime $dt
     * @return bool
     */
    public function isHoliday(DateTime $dt)
    {
        $m = $dt->format("m");
        $d = $dt->format("d");

        return (($m == 7) && ($d == 4));
    }
}