<?php

namespace DPP\Financial\Time;

use \DateTime as DateTime;

use DPP\Financial\FinancialException as FinancialException;

/**
 * Class Continuous
 *
 * @package DPP\Amortization\Time
 */
class Continuous extends Frequency
{
    /**
     * Continuous constructor.
     */
    public function __construct()
    {
        parent::__construct(1, "Continuous", "continuous");
    }

    /**
     * @return float
     */
    public function partOfYear()
    {
        return 0.0;
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        return $this->copy($dt);
    }

    /**
     * @return float|int
     */
    public function termsInAYear()
    {
        return 0.0;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 0;
    }
}