<?php

namespace DPP\Financial\Factorization;

use \DateTime as DateTime;

use DPP\Financial\Interest as Interest;
use DPP\Financial\Time\Frequency as Frequency;

class FactorizationCalculator
{
    const STANDARD_DATE_FORMAT = "Y-m-d";

    private $rate;
    private $amount;
    private $terms;

    /**
     * @var Frequency
     */
    private $paymentFrequency;

    public function __construct()
    {
        $this->rate = null;
        $this->amount = null;
        $this->terms = null;

        $this->paymentFrequency;
    }

    public static function create($ra, $am, $tm = null, Frequency $f)
    {
        $rt = new FactorizationCalculator();

        $rt->rate = $ra;
        $rt->amount = $am;
        $rt->terms = $tm;
        $rt->paymentFrequency = $f;

        return $rt;
    }

    public function run()
    {
        $tt = round(($this->amount * $this->rate), Interest::ROUNDING_PRECISION);
        $apt = $tt;
        $sch = null;

        if($this->terms != null)
        {
            $apt = round(($tt / $this->terms), Interest::ROUNDING_PRECISION);

            $sch = array();
            $ntt = $tt;

            if($this->paymentFrequency != null)
            {
                $ndt = new DateTime();

                while($ntt > 0.0)
                {
                    $ndt = $this->paymentFrequency->getNextDate($ndt);
                    $ntt = ($ntt < $apt) ? $ntt : ($ntt = $apt);

                    $sch[$ndt->format(self::STANDARD_DATE_FORMAT)] = $ntt;
                }
            }
        }

        $rt = new Factorization($tt, $this->rate, $apt, $sch);

        return $rt;
    }
}