<?php

namespace DPP\Financial\Amortization;

/**
 * Class Method
 *
 * @package DPP\Financial\Amortization
 */
class Method
{
    private $id;

    private $name;
    private $shortName;

    private $className;

    /**
     * Method constructor.
     *
     * @param int $i ID
     * @param string $n Name
     * @param string $sn Short name
     * @param string $cn Class name
     */
    public function __construct($i, $n, $sn, $cn)
    {
        $this->id = $i;

        $this->name = $n;
        $this->shortName = $sn;

        $this->className = $cn;
    }

    /** Static initializer for Normal Amortization
     *
     * @return Method
     */
    public static final function NORMAL()
    {
        return new Method(1, "Normal", "normal", "NormalAmortizationCalculator");
    }

    /** Static initializer for Fixed Principal Amortization
     *
     * @return Method
     */
    public static final function FIXED_PRINCIPAL()
    {
        return new Method(2, "Fixed Principal", "fixed_principal", "FixedPrincipalAmortizationCalculator");
    }

    /** Static initializer for Interest Only Amortization
     *
     * @return Method
     */
    public static final function INTEREST_ONLY()
    {
        return new Method(3, "Interest Only", "interest_only", "InterestOnlyAmortizationCalculator");
    }

    /** Gets a list of available Methods
     *
     * @return self[]
     */
    public static final function GetList()
    {
        $rt = array();

        $rt[] = self::NORMAL();
        $rt[] = self::FIXED_PRINCIPAL();
        $rt[] = self::INTEREST_ONLY();

        return $rt;
    }

    /**
     * @return int
     */
    public function id()
    {
        return $this->id;
    }

    /**
     * @return string
     */
    public function name()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function shortName()
    {
        return $this->shortName;
    }

    /**
     * @return string
     */
    public function className()
    {
        return $this->className;
    }
}
