<?php

namespace DPP\Financial\Time;

use \DateTime as DateTime;
use \DateInterval as DateInterval;

use DPP\Financial\FinancialException as FinancialException;

/**
 * Class Monthly
 *
 * @package DPP\Financial\Time
 */
class Monthly extends Frequency
{
    /**
     * Monthly constructor.
     */
    public function __construct()
    {
        parent::__construct(6, "Monthly", "monthly");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return (1 / 12);
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $rt->add(DateInterval::createFromDateString("1 month"));

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 12;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 30;
    }
}