<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime as DateTime;
use \DateInterval as DateInterval;

/**
 * Class PresidentsDay
 *
 * @package DPP\Financial\Time\Holiday
 */
class PresidentsDay extends Holiday
{
    /**
     * PresidentsDay constructor.
     */
    public function __construct()
    {
        parent::__construct(2, "President's Day", "presidents_day");
    }

    /**
     * @param DateTime $dt
     * @return bool
     */
    public function isHoliday(DateTime $dt)
    {
        $y = $dt->format("Y");
        $nd = DateTime::createFromFormat("Y-m-d", sprintf("%s-01-01", $y));

        $wk = 1;
        $d = $nd->format("w");

        while(($d != 1) && ($wk != 3))
        {
            if($d == 1)
            {
                $wk++;
            }

            $nd->add(DateInterval::createFromDateString("1 day"));
            $d = $nd->format("w");
        }

        $ndf = $nd->format("Y-m-d");
        $odf = $dt->format("Y-m-d");

        return ($ndf == $odf);
    }
}