<?php

namespace DPP\Financial\Time\Holiday;

use \DateTime as DateTime;

/**
 * Class NewYearsDay
 *
 * @package DPP\Financial\Time\Holiday
 */
class NewYearsDay extends Holiday
{
    /**
     * NewYearsDay constructor.
     */
    public function __construct()
    {
        parent::__construct(1, "New Year's Day", "new_years_day");
    }

    /**
     * @param DateTime $dt
     * @return bool
     */
    public function isHoliday(DateTime $dt)
    {
        $y = $dt->format("Y");
        $nd = DateTime::createFromFormat("Y-m-d", sprintf("%s-01-01", $y));

        $ndf = $nd->format("Y-m-d");
        $odf = $dt->format("Y-m-d");

        return ($ndf == $odf);
    }
}