<?php

namespace DPP\Financial\Time;

use \DateTime as DateTime;
use \DateInterval as DateInterval;

use DPP\Financial\FinancialException as FinancialException;

/**
 * Class Annually
 *
 * @package DPP\Financial\Time
 */
class Annually extends Frequency
{
    /**
     * Annually constructor.
     */
    public function __construct()
    {
        parent::__construct(9, "Annually", "annually");
    }

    /**
     * @return float|int
     */
    public function partOfYear()
    {
        return 1;
    }

    /**
     * @param DateTime $dt
     * @return DateTime
     * @throws FinancialException
     */
    public function getNextDate(DateTime $dt)
    {
        $rt = $this->copy($dt);
        $rt->add(DateInterval::createFromDateString("1 year"));

        return $rt;
    }

    /**
     * @return int
     */
    public function termsInAYear()
    {
        return 1;
    }

    /**
     * @return int
     */
    public function daysInTerm()
    {
        return 365;
    }
}