<?php

namespace DPP\Financial\Service;

use DPP\Financial\Schedule as Schedule;
use DPP\Financial\ScheduledPayment as ScheduledPayment;
use DPP\Financial\Payment as Payment;
use DPP\Financial\FinancialException as FinancialException;

class ServiceProcessor
{
    /**
     * @var Schedule
     */
    private $schedule;

    /**
     * @var Payment[]
     */
    private $payments;

    private $paidItems;
    private $totalPaid;

    public function __construct()
    {
        $this->schedule;
        $this->payments = array();

        $this->paidItems = 0;
        $this->totalPaid = 0.0;
    }

    /**
     * @param Schedule  $s
     * @param Payment[] $ps
     * @return ServiceProcessor
     */
    public static function Create(Schedule $s, array $ps = array())
    {
        $rt = new ServiceProcessor();
        $pmt = $s->payments();

        $rt->schedule = $s;

        for($i=0; $i<count($pmt); $i++)
        {
            if(!empty($ps[$i]))
            {
                $rt->updateTotals($pmt[$i], $ps[$i]);
            }
        }

        return $rt;
    }

    public function payments()
    {
        return $this->payments;
    }

    /**
     * @param Payment $p
     * @param integer $pn
     * @throws FinancialException
     */
    public function makePayment(Payment $p, $pn = null)
    {
        if($this->paidOff())
        {
            throw new FinancialException("Attempting to make payments on debt that is paid off");
        }

        $pn = (($pn != null) ? $pn : $this->paidItems) - 1;
        $pmt = $this->schedule->payments();

        if(empty($pmt[$pn]))
        {
            throw new FinancialException("Scheduled payment does not exist");
        }

        $this->updateTotals($pmt[$pn], $p);
    }

    public function paidOff()
    {
        return ($this->totalPaid >= $this->schedule->principalTotal());
    }

    private function updateTotals(ScheduledPayment $sp, Payment $p)
    {
        $this->payments[] = $p;

        $this->totalPaid += ($p->amount() - $sp->interest());
        $this->paidItems++;
    }
}