<?php

namespace DPP\Financial;

/**
 * Class IncrementType
 *
 * @package DPP\Financial
 */
class IncrementType
{
    private $id;

    private $name;
    private $shortName;

    private $yearSplitter;

    /**
     * IncrementType constructor.
     *
     * @param int $i
     * @param int $v
     */
    public function __construct($i, $v)
    {
        $this->id = $i;

        $this->name = sprintf("%s/1", $v);
        $this->shortName = sprintf("%s_1", $v);

        $this->yearSplitter = $v;
    }

    /**
     * @return IncrementType[]
     */
    public static final function GetList()
    {
        $rt = array();

        $rt[] = new IncrementType(1,2);
        $rt[] = new IncrementType(2,3);
        $rt[] = new IncrementType(3,4);
        $rt[] = new IncrementType(4,10);

        return $rt;
    }

    /**
     * @param string $n
     * @return IncrementType|null
     */
    public static final function GetByName($n)
    {
        $rt = null;
        $its = self::GetList();

        foreach($its as $i)
        {
            if($i->shortName == $n)
            {
                $rt = $i;
                break;
            }
        }

        return $rt;
    }

    /**
     * @return string
     */
    public function name()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function shortName()
    {
        return $this->shortName;
    }

    /**
     * @return int
     */
    public function years()
    {
        return $this->yearSplitter;
    }
}