<?php

namespace DPP\Financial\Amortization;

use \DateTime as DateTime;

use DPP\Financial\FinancialException as FinancialException;
use DPP\Financial\ScheduledPayment as ScheduledPayment;
use DPP\Financial\Interest as Interest;


/**
 * Class InterestOnlyAmortizationCalculator
 *
 * @package DPP\Financial\Amortization
 */
class InterestOnlyAmortizationCalculator extends AmortizationCalculator
{
    /**
     * InterestOnlyAmortizationCalculator constructor.
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * @param DateTime[] $ds
     * @return ScheduledPayment[]
     */
    protected function fixedSchedule(array $ds)
    {
        $rt = array();
        $ft = $this->totalAmount;

        for($i=0; $i<count($ds); $i++)
        {
            $d = $ds[$i];

            $io = new Interest($d->annual(), $this->compoundFrequency);
            $ip = $io->value($ft, $this->paymentFrequency);

            $pm = 0;

            $d->lock($pm, $ip, $ft);
            $rt[] = $d;

            if($ft <= 0.0)
            {
                break;
            }
        }

        return $rt;
    }

    /**
     * @throws FinancialException
     */
    protected function adHocSchedule()
    {
        throw new FinancialException("Ad hoc not possible for interest-only");
    }
}