<?php

namespace DPP\Decision\Weight;

use DPP\Decision\DecisionException;

class WeightComparator
{
    private $repeatable;

    private $maxCount;

    /**
     * @var WeightedItem[]
     */
    private $items;

    /**
     * @var WeightedItem[]
     */
    private $returned;

    private $itemCounts;

    public function __construct($mc = null, $rpt = false)
    {
        $this->repeatable = $rpt;
        $this->maxCount = $mc;

        $this->items = array();
        $this->returned = array();
        $this->itemCounts = array();
    }

    public function add(Weightable $w)
    {
        $this->items[] = new WeightedItem($w);
    }

    /**
     * @throws DecisionException
     */
    public function getNext()
    {
        $rt = null;
        $cti = count($this->items);

        $cds = array();
        $hiw = 0.0;

        for($i=0; $i<$cti; $i++)
        {
            $ni = $this->items[$i];
            $nid = $ni->identifier();
            $nnw = $this->getWeight($ni);

            if($this->isAlreadyReturned($nid) || ($nnw === 0.0))
            {
                continue;
            }

            if($hiw > $nnw)
            {
                continue;
            }
            else if($nnw > $hiw)
            {
                $hiw = $nnw;
                $cds = array();
            }

            $cds[] = $ni;
        }

        if(!empty($cds))
        {
            $nrt = $cds[array_rand($cds)];
            $rt = $this->rotateLists($nrt);
        }

        return $rt;
    }

    public function rewind($n)
    {
        while($n > 0)
        {
            $this->deRotate();
            $n--;
        }
    }

    public function isSaturated()
    {
        $rt = true;

        foreach($this->items as $i)
        {
            $id = $i->identifier();

            if(!empty($this->itemsCount[$id]) && (count($this->itemsCount[$id]) >= $this->maxCount))
            {
                $rt = false;
                break;
            }
        }

        return $rt;
    }

    public function sortByWeight()
    {

    }

    private function isAlreadyReturned($id)
    {
        $rt = false;

        if(!$this->repeatable)
        {
            foreach($this->returned as $r)
            {
                if($id == $r->identifier())
                {
                    $rt = true;
                    break;
                }
            }
        }

        return $rt;
    }

    private function getWeight(WeightedItem $w)
    {
        $wi = $w->item();
        $rt = $w->weight();
        $mod = 1.0;

        if(!empty($this->itemCounts[$nid]) && ($this->maxCount !== null))
        {
            if($this->itemCounts[$nid] === $this->maxCount)
            {
                $mod = 0.0;
            }
            else
            {
                $mod = 1.0 - ($this->itemCounts[$nid] / $this->maxCount);
            }
        }

        $rt *= $mod;

        return $rt;
    }

    private function deRotate()
    {
        $la = array_pop($this->returned);
        $id = $la->identifier();

        $this->itemCounts[$id]--;
    }

    private function rotateLists($rt)
    {
        $rt->place(count($this->returned) + 1);

        $this->returned[] = $rt;
        $id = $rt->identifier();

        if(empty($this->itemCounts[$id]))
        {
            $this->itemCounts[$id] = 0;
        }

        $this->itemCounts[$id]++;

        return $rt->item();
    }
}