<?php

namespace DPP\Decision\Weight\Deal;

use DPP\Decision\Weight\Weightable;

class Investor implements Weightable
{
    private $id;

    private $totalAvailable;
    private $totalPerCommitment;

    private $dealsAwarded;
    private $artificialWeight;
    private $distanceFromAverageRatio;
    private $timeLeft;

    public function __construct($i, $tpc, $ta, $tft, $dls = 0, $aw = 0.0, $dfar = 0.0)
    {
        $this->id = $i;

        $this->totalAvailable = $ta;
        $this->totalPerCommitment = $tpc;

        $this->dealsAwarded = $dls;
        $this->artificialWeight = $aw;
        $this->distanceFromAverageRatio = $dfar;
        $this->timeLeft = $tft;
    }

    public function weight()
    {
        $taz = ($this->totalAvailable <= 0);
        $tzr = ($this->timeLeft <= 0);

        $tar = (!$taz) ? log(($this->totalAvailable / $this->totalPerCommitment), 10) : 0.0;
        $tta = (!$taz) ? log($this->totalAvailable, 10) : 0.0;
        $dar = log((1 / $this->distanceFromAverageRatio), 10);
        $tlf = (!$tzr) ? log(($this->timeLeft / (($this->dealsAwarded !== 0) ? $this->dealsAwarded : 1.0)), 10) : 0.0;
        $daw = -1 * (($this->dealsAwarded > 0) ? log($this->dealsAwarded, 10) : 1);
        $art = $this->artificialWeight;

        $rt = ($tta) + ($tar) + ($dar) + ($art) + ($tlf) + ($daw);

        return $rt;
    }

    public function id()
    {
        return $this->id;
    }

    public function canHandle($amt)
    {
        return (($amt <= $this->totalPerCommitment) && ($amt <= $this->totalAvailable));
    }

    public function limit()
    {
        return $this->totalPerCommitment;
    }

    public function available()
    {
        return $this->totalAvailable;
    }
}