<?php

namespace DPP\Decision\Weight\Deal;

use \DateTime;
use \DateInterval;

use DPP\Decision\Weight\WeightComparator;

class DealComparator
{
    private $maxInvestors;
    private $comparator;

    private $average;
    private $dateStarted;

    public function __construct($mi, $avg, DateTime $dt)
    {
        $this->maxInvestors = $mi;
        $this->comparator = new WeightComparator();

        $this->average = $avg;
        $this->daysUntilEndOfMonth = $this->daysUntilEndOfMonth($dt);
    }

    public function add($i, $m, $a, $d, $aw)
    {
        $dfa = $m / $this->average;
        $tft = $this->daysUntilEndOfMonth;
        $inv = new Investor($i, $m, $a, $tft, $d, $aw, $dfa);

        $this->comparator->add($inv);
    }

    public function get($td)
    {
        $rt = array();

        while($td > 0.0)
        {
            $ni = $this->comparator->getNext();

            if(($ni === null) || (count($rt) >= $this->maxInvestors))
            {
                break;
            }

            $id = $ni->id();

            if(array_key_exists($id, $rt))
            {
                continue;
            }

            if(!$ni->canHandle($td))
            {
                $lmt = $ni->limit();
                $ava = $ni->available();

                $amt = ($ava < $lmt) ? $ava : $lmt;

                $rt[$id] = array('lender' => $ni, 'amount' => $amt);
                $td -= $amt;
            }
            else
            {
                $rt[$id] = array('lender' => $ni, 'amount' => $td);
                $td = 0.0;
            }
        }

        return $rt;
    }

    private function daysUntilEndOfMonth(DateTime $dt)
    {
        $y = $dt->format("Y");
        $m = $dt->format("m");
        $d = 1;

        $eom = new DateTime();
        $eom->setDate($y, $m, $d);
        $eom->add(DateInterval::createFromDateString("1 month"));

        $rt = $eom->diff($dt);
        return $rt->days;
    }
}