<?php

namespace DPP\Decision\Weight;

class AmountComparator
{
    private $comparator;

    public function __construct($mc)
    {
        $this->comparator = new WeightComparator($mc);
    }

    public function add($i, $a)
    {
        $this->comparator->add(new Account($i, $a));
    }

    public function getNext($amt)
    {
        $rt = parent::getNext();
        $rw = 0;

        while(!$rt->canHandle($amt))
        {
            $rt = parent::getNext();
            $rw++;

            if($rt === null)
            {
                $this->rewind($rw);
                break;
            }
        }

        return $rt;
    }
}