<?php

namespace DPP\Decision\Weight\Account;

use DPP\Decision\Weight\Weightable;

class Account implements Weightable
{
    private $id;

    private $totalAvailable;
    private $committments;

    public function __construct($i, $ta)
    {
        $this->id = $i;

        $this->totalAvailable = $ta;
        $this->committments   = array();
    }

    public function addCommittment($a)
    {
        $this->committments[] = $a;
    }

    public function weight()
    {
        $tc = $this->totalCommittments();

        $rt = ($this->totalAvailable / 100) * (1.0 - ($tc / $this->totalAvailable));
        return $rt;
    }

    public function id()
    {
        return $this->id;
    }

    public function canHandle($amt)
    {
        return ($amt <= $this->available());
    }

    public function totalCommittments()
    {
        $rt = 0.0;

        foreach($this->committments as $c)
        {
            $rt += $c;
        }

        return $rt;
    }

    public function available()
    {
        return $this->totalAvailable - $this->totalCommittments();
    }
}