<?php

namespace DPP\Decision\Rank;

use DPP\Decision\DecisionException;

class RankingRuleFactory
{
    public static function Get(string $t, string $fa, string $f, string $v = null)
    {
        $rt = null;

        switch($t)
        {
            case 'discrete_rank': { $rt = new DiscreteRankingRule($fa, $f); break; }
            default: {throw new DecisionException(sprintf("Invalid ranking rule '%s'", $t)); break; }
        }

        return $rt;
    }
}

?>