<?php

namespace DPP\Decision\Rank;

class DiscreteRankingRule extends RankingRule
{
    private $formula;
    private $breakdown;

    public function __construct(string $fd, string $f)
    {
        parent::__construct($fd);

        $this->formula = $f;
        $this->breakdown = array();

        $this->parse();
    }

    public function rank($a)
    {
        $rt = 0;

        foreach($this->breakdown as $aa)
        {
            $min = $aa['range']['min'];
            $max = $aa['range']['max'];

            $rt = ((($min == null) || ($a >= $min)) && (($max == null) || ($a <= $max))) ? $aa['value'] : 0;
        }

        return $rt;
    }

    public function invert($a)
    {
        return -$this->rank($a);
    }

    private function parse()
    {
        $ars = explode("\n", $this->formula);

        foreach($ars as $a)
        {
            $arsa = explode(":", $a);
            $ata = null;

            $arsa[0] = trim($arsa[0]);
            $arsa[1] = trim($arsa[1]);

            $nr = array(
                'range' => array(
                    'min'   => null,
                    'max'   => null
                ),
                'value' => null
            );

            if(preg_match("/^(\d+)\s*\-\s*$/", $arsa[0], $ata))
            {
                $nr['range']['max'] = $ata[1];
            }
            else if(preg_match("/^(\d+)\s*\+\s*$/", $arsa[0], $ata))
            {
                $nr['range']['min'] = $ata[1];
            }
            else if(preg_match("/^(\d+)\s*\-\s*(\d+)\s*$/", $arsa[0], $ata))
            {
                $nr['range']['max'] = $ata[2];
                $nr['range']['min'] = $ata[1];
            }

            $nr['value'] = (float) $arsa[1];
            $this->breakdown[] = $nr;
        }
    }
}