<?php

namespace DPP\Decision\Weight\Deal;

use DPP\Decision\Weight\Weightable;

class Investor implements Weightable
{
    private $id;

    private $totalAvailable;
    private $totalPerCommitment;

    public function __construct($i, $tpc, $ta)
    {
        $this->id = $i;

        $this->totalAvailable = $ta;
        $this->totalPerCommitment = $tpc;
    }

    public function weight()
    {
        $tar = $this->totalPerCommitment / $this->totalAvailable;
        $rt = ($this->totalAvailable / 100) * $tar;

        return $rt;
    }

    public function id()
    {
        return $this->id;
    }

    public function canHandle($amt)
    {
        return (($amt <= $this->totalPerCommitment) && ($amt <= $this->totalAvailable));
    }

    public function limit()
    {
        return $this->totalPerCommitment;
    }
}