<?php
/**
 * Created by PhpStorm.
 * User: matt.d
 * Date: 7/18/2018
 * Time: 12:21 PM
 */

namespace DPP\Decision\Weight\Deal;

use DPP\Decision\Weight\WeightComparator;

class DealComparator
{
    private $maxInvestors;
    private $comparator;

    public function __construct($mi, $pt = false)
    {
        $this->maxInvestors = $mi;
        $this->comparator = new WeightComparator();
    }

    public function add($i, $m, $a)
    {
        $this->comparator->add(new Investor($i, $m, $a));
    }

    public function get($td)
    {
        $rt = array();

        while($td > 0.0)
        {
            $ni = $this->comparator->getNext();

            if(($ni === null) || (count($rt) >= $this->maxInvestors))
            {
                break;
            }

            $id = $ni->id();

            if(array_key_exists($id, $rt))
            {
                continue;
            }

            if(!$ni->canHandle($td))
            {
                $rt[$id] = array('lender' => $ni, 'amount' => $ni->limit());
                $td -= $ni->limit();
            }
            else
            {
                $rt[$id] = array('lender' => $ni, 'amount' => $td);
                $td = 0.0;
            }
        }

        return $rt;
    }
}